/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.asistente.exportacion.valores;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.ModeloValores;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.LocalDate;

public class ModeloValoresCompExportacion
implements ModeloValores {
    private boolean inicializado;
    private final Map<String, ElementoNombreValor<String>> comprobantes;
    private final LocalDate fechaDeclarada;

    public void inicializar() {
        if (!this.inicializado) {
            this.cargarComprobantes();
            this.inicializado = true;
        }
    }

    public ModeloValoresCompExportacion(LocalDate fechaDeclarada) {
        this.fechaDeclarada = fechaDeclarada;
        this.comprobantes = new LinkedHashMap<String, ElementoNombreValor<String>>();
    }

    private void cargarComprobantes() {
        this.comprobantes.clear();
        Map comprobantesObtenidos = UtilCatalogosATS.crearInstancia().obtenerComprobantesPorTransaccion("4", this.fechaDeclarada);
        for (Map.Entry comp : comprobantesObtenidos.entrySet()) {
            this.comprobantes.put((String)comp.getKey(), (ElementoNombreValor<String>)new ElementoNombreValor(String.valueOf((String)comp.getKey()) + "-" + (String)comp.getValue(), (Object)((String)comp.getKey())));
        }
    }

    public List<ElementoNombreValor<String>> getTipoComprobante() {
        return new ArrayList<ElementoNombreValor<String>>(this.comprobantes.values());
    }

    public ElementoNombreValor<String> obtenerTipoComprobante(String tipoComprobante) {
        return StringUtil.isNullOrEmpty((String)tipoComprobante) ? null : this.comprobantes.get(tipoComprobante);
    }
}

